# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Intuition was pretty similar to 'Find Eventual Safe States(802)(Yesterday's daily challenge)'. 

Simply they don't have to form cycles.

Anyway it required a visualisation that courses that was prerequisite of other course(s) must have to be completed before, and in order to do that they must be not required to complete those courses whom they are prerequisite of. 



# Approach
<!-- Describe your approach to solving the problem. -->
Used List to store courses and their prerequisite(s).

For every course check if it is part of any loop or not ( used a separate function for that ).

Used enum for storing the status of course, it was usefull in checking the presence of loops.

[ If something is not understandable, then please let me know in comments, I will explain that further. ]    :)

# Complexity 
 
- Time complexity : $$O( ∣N∣ + ∣P∣ )$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O( ∣N∣ + ∣P∣ )$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

where , N = numCourses : P = prerequisites.length ( rows )
# Code
```
enum Course{
    Completing,
    Completed
}

class Solution {
    public boolean canFinish(int numCourses, int[][] prerequisites) {
        Course[] courses = new Course[numCourses];
        List<Integer>[] li = new List[numCourses];
        for( int i = 0; i < numCourses; i++){
            li[i] = new ArrayList<>();
        }
        for( int[] pre : prerequisites){
            li[ pre[0]].add( pre[1]);
        }
        for( int i = 0; i < numCourses; i++){
            if( checkLoop( i, li, courses)){
                return false;
            }
        }
        return true;
    }

    boolean checkLoop( int a, List<Integer>[] li, Course[] c){

        if( c[a] == Course.Completing){
            return true;
        }
        if( c[a] == Course.Completed){
            return false;
        }

        c[a] = Course.Completing;
        for( int p : li[a]){
            if( checkLoop( p, li, c)){
                return true;
            }
        }
        c[a] = Course.Completed;
        return false;
     }
}
```